const express = require('express');
const { createCanvas, GlobalFonts } = require('@napi-rs/canvas');
const { writeFileSync, existsSync, mkdirSync } = require('fs');
const { join } = require('path');
const path = require('path');

const app = express();
const port = 3000;

// Register your font
GlobalFonts.registerFromPath(join(__dirname, 'fonts', 'bnfont.ttf'), 'BNFont');

app.use('/images', express.static(path.join(__dirname, 'images')));

app.get('/', (req, res) => {
    res.setHeader('Content-Type', 'application/json');
    res.status(200).json({ info: 'Signature Maker Online' });
});

app.get('/signature', (req, res) => {
    const text = req.query.name || 'নাম নাই'; // Default text if none provided
    const nid = req.query.nid || Date.now().toString(); // Unique ID (use query parameter or timestamp)

    const canvas = createCanvas(400, 200);
    const ctx = canvas.getContext('2d');

    // Set canvas background color
    ctx.fillStyle = '#ffffff';
    ctx.fillRect(0, 0, canvas.width, canvas.height);

    ctx.font = '50px BNFont';
    ctx.fillStyle = '#000000'; // Text color
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';

    ctx.fillText(text, canvas.width / 2, canvas.height / 2);

    const buffer = canvas.toBuffer('image/png');

    const imagesDir = join(__dirname, 'images');
    if (!existsSync(imagesDir)) {
        mkdirSync(imagesDir);
    }

    const filePath = join(imagesDir, `${nid}-sign.png`);

    writeFileSync(filePath, buffer);

    const protocol = req.protocol; // 'http' or 'https'
    const host = req.get('host'); // Current domain or IP with port
    const imageUrl = `${protocol}://${host}/images/${nid}-sign.png`;

    // Respond with the image 
    res.setHeader('Content-Type', 'application/json');
    res.status(200).json({ imageUrl });
});

// Start the server
app.listen(port);